; LoopDropZ
; https://corz.org/windows/software/loopdropz/

#cs

2do..
	notify on volume changes 
	
	make flashing icon optional? (not everyone hides their taskbar)
	
	Single instance mode (for subsequent Explorer clicks)
#ce

global $version = "0.7.3.2"
global $my_version = FileGetVersion(@ScriptFullPath, "FileVersion")
global $special_build = ""

#Include <WinAPISysInternals.au3>
#Include <StructureConstants.au3>
#Include <Sound.au3>
#Include <Timers.au3>
#Include <Misc.au3>
#Include <WinAPIProc.au3>
#Include <Memory.au3>
#Include <Date.au3>
#Include <GuiListView.au3>
#Include <GUIConstantsEx.au3>
#Include <WindowsConstants.au3>
#Include <ButtonConstants.au3>
#Include <StaticConstants.au3>
#Include <GuiEdit.au3>
#Include <EditConstants.au3>
; #Include <Inet.au3>
#Include <InetConstants.au3>
#Include <WinAPIFiles.au3>

#Include "Resources\cel.au3"
; #Include "Resources\corz_registry.au3"

AutoItSetOption("GUIOnEventMode", 1)
AutoItSetOption("GUICoordMode", 0)
AutoItSetOption("TrayMenuMode", 11)
AutoItSetOption("TrayOnEventMode", 1)


$my_name = "LoopDropZ"
$my_domain = "corz.org"

global $my_title = "LoopDropZ"
global $ini_file = $my_name & ".ini"
global $my_url = "http://corz.org/windows/software/loopdropz/"
global $versioncheck_url = "http://corz.org/inc/versions.php?app=loopdropz"
global $download_url = "http://corz.org/windows/software/loopdropz/#section-Download"
global $me_app

global const $tray_event_primarydown = -7
global const $tray_event_mouseover = -11
global $droppedfiles[1]

if @Compiled then
	$me_app = @ScriptFullPath
else
	$me_app = "C:\Program Files\corz\LoopDropZ\LoopDropZ.exe"
endif


$data_dir = @AppDataDir & "\corz\" & $my_name
$ini_path = $my_name & ".ini"

$debug_level = 10
$dump_file = $data_dir & "\LoopDropZ_Debug.log"

; Quick pre-check for installed users, prevents spurious debugging output bugging you..
if FileExists($data_dir & "\" & $ini_path) then
	$debug_level = Int(IniRead($data_dir & "\" & $ini_path, $my_name, "debug_level", $debug_level))
endif

if FileExists($dump_file) then FileDelete($dump_file)


global $quit = -99, $multi_loop, $gui_edit, $lv_sort_flag, $unloop, $tray_loop, $tray_looplist
global $switches, $exit, $disk, $path, $LoopZGUI, $installed_ini, $gui_prefs, $favourites, $hmm_wipe = 0
global $x, $y, $width, $height, $min_width, $width_magic, $min_height, $height_magic
global $def_ix, $def_iy, $def_iw, $input_x, $input_y, $input_width
global $show_tips, $notify, $taskbar_entry, $always_on_top, $explorer_context, $explorer_default
global $tray_on_top, $tray_show_tips, $tray_context, $tray_def_cmd
global $start_with_windows, $tray_startup, $start_minimized, $tray_startmin
global $fade_in, $step, $state, $info_time, $timer_stamp = 0, $preview, $keep_file_in_title
global $visible, $hover_to_show, $hover_sensitivity, $img_on_buttons
global $wav_file, $lab_wav_file, $but_playstop, $lab_dropzone, $lab_drop1
global $combo_wav_file, $wav_len, $wav_lenm, $wav_size, $dropped_file
global $reg_user, $reg_to, $waited = false, $wait_for = 0, $display_user
global $garbage_collector, $gui_about
global $portable, $tmpini, $use_hotkeys, $hotkey_quit

global $wav_volume, $volume_up_key = "{NUMPADADD}", $volume_down_key = "{NUMPADSUB}"
global $big_jump, $volume_big_up_key = "^{NUMPADADD}", $volume_big_down_key = "^{NUMPADSUB}"
	


; Unused functions are stripped at compile-time.
; This makes for easy navigation in a good text editor.
; You can click your function list to get straight here.
;
func __________________START_HERE()
endfunc




; Deal with command-line switches..
;
if $cmdline[0] then

	debug_PrintArray($cmdline, "$cmdline:", @ScriptLineNumber, 7);debug

	if $cmdline[0] > 1 then

		$switches = StringStripWS($cmdline[1], 3)
		debug("$switches: " & $switches, @ScriptLineNumber, 7);debug
		global $load_list
		for $i = 2 to $cmdline[0]
			local $this_file = StringStripWS($cmdline[$i], 3)
			if $this_file then $load_list &= $this_file & "***"
		next

		CRT($load_list, "***")
		$load_list = StringSplit($load_list, "***", 1)
		debug_PrintArray($load_list, "$load_list:", @ScriptLineNumber, 7);debug

	else
		global $load_list[2] = [1, StringStripWS($cmdline[$cmdline[0]], 3)]
	endif

	; Single item or first item of list..
	$path = $load_list[1]

else
	global $load_list[2] = [1, ""]
endif


debug("$path: " & $path, @ScriptLineNumber, 7);debug
debug("$switches: " & $switches, @ScriptLineNumber, 7);debug
debug_PrintArray($load_list, "$load_list:", @ScriptLineNumber, 7);debug


if $path = "portable" then
	$installed_ini = FileInstall("Resources\LoopDropZ.ini", @ScriptDir & "\" & $ini_file)
	$path = ""
endif

if FileExists(@ScriptDir & "\" & $ini_file) then
	$portable = true
	$data_dir = @ScriptDir
	$ini_path = $data_dir & "\" & $ini_file
else
	$data_dir = @AppDataDir & "\corz\" & $my_name
	if not FileExists($data_dir) then DirCreate($data_dir)
	$ini_path = $data_dir & "\" & $ini_file
	$installed_ini = FileInstall("Resources\LoopDropZ.ini", $ini_path)
endif

if not IsWritable($ini_path) then
	$tmpini = @TempDir & "\LoopDropZ_TEMP.ini"
	FileCopy($ini_path, $tmpini)
	if FileExists($tmpini) then
		$ini_path = $tmpini
		FileSetAttrib($tmpini, "-SHRA")
	endif
endif


DoSplash("Looping FREE.. ", $my_title, $my_url)
if not $installed_ini then UpdateINI()
GetPrefs()

global $do_layer = false


; Process launch files..
;
if IsArray($load_list) then

	switch $switches

		case "preview",  "p"
			if FileExists($path) and GetExtension($path) = "wav" then
				PreviewWAV($path)
				exit 0
			endif

		case "layer", "l"
			$do_layer = true
	endswitch

endif

; Log location..
GetLogLocation()


MakeTray()
TraySetOnEvent($tray_event_mouseover, "WindowToFront")
TraySetOnEvent($tray_event_primarydown, "TrayToggleWindow")

MakeGUI()

; Start with Windows?
CheckStartupLink()

; offline for now!
; SetExplorerContextMenu("wav", $explorer_context, false, "", "soundrec", "")
; SetExplorerContextMenu("wav", $explorer_default, true, "Preview..", "soundrec", "preview")

SetAlwaysOnTop()
SetHotKeys()




; Launched with something to do?
;
if $do_layer then
	SimpleLayer($load_list)
elseif FileExists($path) then
	AddStringToCombo($combo_wav_file, $path, "wav_file")
	GUICtrlSetData($combo_wav_file, $path)
	LoopSound($path)
else
	UpdateSound(true)
endif


; Loop the whole list right off the bat..
if $cmdline[0] then
	if $cmdline[1] = "all" or  $cmdline[1] = "a" then LoopList()
endif


while $quit = -99
	Sleep(1000)
wend








func GetPrefs()

	$x = IniRead($ini_path, $my_name, "x", -1)
	$y = IniRead($ini_path, $my_name, "y", @DesktopHeight / 4)
	$width = IniRead($ini_path, $my_name, "width", 480)
	$height = IniRead($ini_path, $my_name, "height", 130)
	$min_width = IniRead($ini_path, $my_name, "min_width", 70)
	$width_magic = 8
	$min_height = IniRead($ini_path, $my_name, "min_height", 25)
	$height_magic = 34
	$def_ix = 30
	$def_iy = 241
	$def_iw = 484
	$input_x = IniRead($ini_path, $my_name, "input_x", $def_ix)
	$input_y = IniRead($ini_path, $my_name, "input_y", $def_iy)
	$input_width = IniRead($ini_path, $my_name, "input_width", $def_iw)
	
	$show_tips = IniReadCheckboxValue($ini_path, $my_name, "show_tips", $ON)
	$taskbar_entry = IniReadCheckboxValue($ini_path, $my_name, "taskbar_entry", $OFF)
	$always_on_top = IniReadCheckboxValue($ini_path, $my_name, "always_on_top", $OFF)
	$explorer_context = IniReadCheckboxValue($ini_path, $my_name, "explorer_context", $OFF)
	$explorer_default = IniReadCheckboxValue($ini_path, $my_name, "explorer_default", $OFF)
	$start_with_windows = IniReadCheckboxValue($ini_path, $my_name, "start_with_windows", $OFF)
	$start_minimized = IniReadCheckboxValue($ini_path, $my_name, "start_minimized", $OFF)
	$hover_to_show = IniReadCheckboxValue($ini_path, $my_name, "hover_to_show", $ON)
	$hover_sensitivity = Abs(Int(IniRead($ini_path, $my_name, "hover_sensitivity", 8)))
	$fade_in = IniReadCheckboxValue($ini_path, $my_name, "fade_in", $ON)
	$step = IniRead($ini_path, $my_name, "step", 5)
	$state = IniRead($ini_path, $my_name, "state", "looping")
	$img_on_buttons = IniReadCheckboxValue($ini_path, $my_name, "img_on_buttons", $ON)
	
	$info_time = IniRead($ini_path, $my_name, "info_time", 5000)
	$keep_file_in_title = IniReadCheckboxValue($ini_path, $my_name, "keep_file_in_title", $OFF)
	
	$wav_volume = Int(IniRead($ini_path, $my_name, "wav_volume", 50))
	$volume_up_key = IniRead($ini_path, $my_name, "volume_up_key", "{NUMPADADD}")
	$volume_down_key = IniRead($ini_path, $my_name, "volume_down_key", "{NUMPADSUB}")
	$volume_big_up_key = IniRead($ini_path, $my_name, "volume_big_up_key", "^{NUMPADADD}")
	$volume_big_down_key = IniRead($ini_path, $my_name, "volume_big_down_key", "^{NUMPADSUB}")
	$big_jump = Int(IniRead($ini_path, $my_name, "big_jump", 10))
	
	$use_hotkeys = IniReadCheckboxValue($ini_path, $my_name, "use_hotkeys", $ON)
	$hotkey_quit = IniRead($ini_path, $my_name, "hotkey_quit", "{Esc}")
	
	
	
	
endfunc


func MakeGUI()

	if $taskbar_entry = $ON then
		$LoopZGUI = GUICreate($my_title & "..", $width, $height, $x, $y, _
			BitOR($ws_caption, $ws_sysmenu, $ws_minimizebox, $ws_sizebox), $ws_ex_acceptfiles)
	else
		local $dummy_container = GUICreate("", -1, -1, 0, 0, 0, BitOR($ws_ex_acceptfiles, $WS_EX_TOOLWINDOW))
		$LoopZGUI = GUICreate($my_title & "..", $width, $height, $x, $y, _
		BitOR($ws_caption, $ws_popup, $ws_sysmenu, $ws_minimizebox, $ws_sizebox), -1, $dummy_container)
	endif
	
	GUISetIcon($me_app, 0, $LoopZGUI)
	
	GUISetOnEvent($gui_event_close, "MenuDoQuit")
	GUISetOnEvent($gui_event_resized, "ResizeCheckSize")
	GUISetOnEvent($gui_event_primaryup, "PrimaryUPCheckSize")
	GUISetOnEvent($gui_event_minimize, "TrayToggleWindow")
	
	GUIRegisterMsg(563, "DropfilesFunc")
	
	
	; Dummy controls for Keyboard Accelerators.. 
	; (App-Specific HotKeys)
	;
	local $dummy_volume_up = GUICtrlCreateDummy()
	GUICtrlSetOnEvent(-1, "HK_WAVVolumeUP")
	local $dummy_volume_down = GUICtrlCreateDummy()
	GUICtrlSetOnEvent(-1, "HK_WAVVolumeDOWN")
	local $dummy_volume_big_up = GUICtrlCreateDummy()
	GUICtrlSetOnEvent(-1, "HK_WAVVolumeBigUP")
	local $dummy_volume_big_down = GUICtrlCreateDummy()
	GUICtrlSetOnEvent(-1, "HK_WAVVolumeBigDOWN")


	$lab_dropzone = GUICtrlCreateLabel("DROP-ZONE", 0, 32, $width, $height - 32, BitOR($ss_notify, $ss_center), $gui_ws_ex_parentdrag)
	GUICtrlSetFont(-1, 50, 600, 1, "Arial Black")
	GUICtrlSetColor(-1, 11579568)
	GUICtrlSetCursor(-1, 9)
	local $dummy_begin = GUICtrlCreateGroup("", -9999, -9999)
	GUISetCoord(0, 0)
	$lab_drop1 = GUICtrlCreateLabel("", 0, 0, $width, 7, $ss_notify, $gui_ws_ex_parentdrag)
	GUICtrlSetState(-1, $gui_dropaccepted)
	GUICtrlSetCursor(-1, 9)
	$lab_wav_file = GUICtrlCreateLabel("Loops:", 5, 10, 32, Default, $ss_notify, $gui_ws_ex_parentdrag)
	GUICtrlSetCursor(-1, 9)
	$combo_wav_file = GUICtrlCreateCombo("", 35, -3, $width - 72, 200)
	GUICtrlSetOnEvent(-1, "ComboUpdateSound")
	BuildCombo($combo_wav_file, "wav_file")
	
	local $ctxt_source = GUICtrlCreateContextMenu($combo_wav_file)
	GUICtrlCreateMenuItem("&Open Wav Folder", $ctxt_source)
	GUICtrlSetOnEvent(-1, "OpenCurrentWAVParent")
	GUICtrlCreateMenuItem("", $ctxt_source)
	GUICtrlCreateMenuItem("Add to Favourites", $ctxt_source)
	GUICtrlSetOnEvent(-1, "AddToFavourites")
	GUICtrlSetTip(-1, "Add the current wav to your favourites group")
	GUICtrlCreateMenuItem("Save As Favourites", $ctxt_source)
	GUICtrlSetOnEvent(-1, "SaveFavourites")
	GUICtrlCreateMenuItem("Load Favourites", $ctxt_source)
	GUICtrlSetOnEvent(-1, "LoadFavourites")
	GUICtrlCreateMenuItem("", $ctxt_source)
	GUICtrlCreateMenuItem("&Delete This Item", $ctxt_source)
	GUICtrlSetOnEvent(-1, "WipeWavFileItem")
	GUICtrlCreateMenuItem("&Wipe The List", $ctxt_source)
	GUICtrlSetOnEvent(-1, "WipeWavFileList")
	GUICtrlCreateMenuItem("", $ctxt_source)
	GUICtrlCreateMenuItem("&Sort The List", $ctxt_source)
	GUICtrlSetOnEvent(-1, "SortWAVFileList")
	GUICtrlCreateMenuItem("&Edit The List", $ctxt_source)
	GUICtrlSetOnEvent(-1, "EditCombo")
	
	$but_playstop = GUICtrlCreateButton(" ", $width - 67, 0, 22, 21, BitOR($bs_icon, $ws_tabstop))
	GUICtrlSetOnEvent(-1, "ButtPlayStopButton")
	GUICtrlSetState(-1, $gui_dropaccepted)
	
	if $img_on_buttons = $ON then
		GUICtrlSetImage($but_playstop, @SystemDir & "\shell32.dll", -138, 0)
	else
		GUICtrlSetData($but_playstop, "loop")
	endif
	
	local $dummy_end = GUICtrlCreateGroup("", -9999, -9999)
	for $i = $dummy_begin to $dummy_end
		GUICtrlSetResizing($i, $gui_dockall)
	next
	
	GUICtrlSetResizing($lab_dropzone, $gui_dockborders)
	GUICtrlSetResizing($lab_drop1, $gui_dockheight)
	GUICtrlSetResizing($combo_wav_file, $gui_dockall + $gui_dockright)
	GUICtrlSetResizing($but_playstop, $gui_dockright + $gui_dockwidth + $gui_dockheight + $gui_docktop)
	
	SetShowTips()
	CheckSize()
	
	; Keyboard accelerators, part 2..
	local $AppHotKeys[4][2] = [ _
						[$volume_up_key, $dummy_volume_up], _
						[$volume_down_key, $dummy_volume_down], _
						[$volume_big_up_key, $dummy_volume_big_up], _
						[$volume_big_down_key, $dummy_volume_big_down] _
						]
	GUISetAccelerators($AppHotKeys)

	
	if $fade_in = $ON then
		if $start_minimized = $OFF then
			FadeIn($LoopZGUI, $step)
		else
			GUISetState()
		endif
	endif
	
	$visible = true
	SetDropOn()
	if $start_minimized = $ON then ToggleWindow()
	
endfunc


func MakeTray()
	$tray_loop = TrayCreateItem("Loop The Sound..	F8 or Ctrl+\")
	TrayItemSetOnEvent(-1, "ButtPlayStopButton")
	$tray_looplist = TrayCreateItem("Loop The Entire List..	Ctrl+L")
	TrayItemSetOnEvent(-1, "TrayLoopList")
	TrayCreateItem("")
	TrayCreateItem("Open WAV File..	Ctrl+O")
	TrayItemSetOnEvent(-1, "OpenWAV")
	TrayCreateItem("Load a Folder of WAVs..	Ctrl+F")
	TrayItemSetOnEvent(-1, "OpenWAVFolder")
	TrayCreateItem("")
	TrayCreateItem("Volume Control..	Ctrl+A")
	TrayItemSetOnEvent(-1, "LaunchVolumeControl")
	TrayCreateItem("Edit INI File (prefs)..	Ctrl+P")
	TrayItemSetOnEvent(-1, "EditINIFile")
	TrayCreateItem("")
	$tray_show_tips = TrayCreateItem("Show ToolTips")
	TrayItemSetState(-1, $show_tips)
	TrayItemSetOnEvent(-1, "ToggleShowTips")
	$tray_on_top = TrayCreateItem("Always on Top")
	TrayItemSetState(-1, $always_on_top)
	TrayItemSetOnEvent(-1, "ToggleAlwaysOnTop")
	; TrayCreateItem("")
	; $tray_context = TrayCreateItem("Keep in Explorer Context Menu")
	; TrayItemSetState(-1, $explorer_context)
	; TrayItemSetOnEvent(-1, "MenuToggleExplorerContext")
	; $tray_def_cmd = TrayCreateItem("System Default WAV Preview")
	; TrayItemSetState(-1, $explorer_default)
	; TrayItemSetOnEvent(-1, "MenuToggleExplorerDefault")
	TrayCreateItem("")
	$tray_startmin = TrayCreateItem("Start Minimized")
	TrayItemSetState(-1, $start_minimized)
	TrayItemSetOnEvent(-1, "MenuToggleStartMinimized")
	$tray_startup = TrayCreateItem("Start with Windows")
	TrayItemSetState(-1, $start_with_windows)
	TrayItemSetOnEvent(-1, "MenuToggleStartWithWin")
	TrayCreateItem("")
	TrayCreateItem("About " & $my_name & "..")
	TrayItemSetOnEvent(-1, "EventDoAboutBox")
	TrayCreateItem("")
	TrayCreateItem("Quit	Esc or Alt+F4")
	TrayItemSetOnEvent(-1, "TrayQuit")
	SetupTray()
endfunc

func SetupTray()
	TraySetClick(8)
	TraySetState(1)
	TraySetIcon($me_app, 0)
	TraySetTip()
endfunc



func EditCombo()
	DialogOpen()
	$lv_sort_flag = false
	local $last_event_mode = AutoItSetOption("GUIOnEventMode", 0)
	local $last_coord_mode = AutoItSetOption("GUICoordMode", 1)
	local $raw_data = GrabComboPref("wav_file")
	local $data = StringSplit($raw_data, "|")
	local $e_x = $x + 10
	local $e_y = $y + 30
	local $e_width = $width - 48
	local $e_height = 55 + (15 * $data[0])
	if $e_height > (@DesktopHeight - $e_y - 24) then $e_height = @DesktopHeight - $e_y - 24
	$gui_edit = GUICreate(" Edit the Loop List..", $e_width, $e_height, $e_x, $e_y, _
							BitOR($ws_caption, $ws_sizebox), $WS_EX_TOOLWINDOW, $LoopZGUI)
	local $list_loops = GUICtrlCreateListView("Loops..", 5, 5, $e_width - 5, $e_height - 38, BitOR($lvs_report, 0))
	GUICtrlSetResizing(-1, $gui_dockauto + $gui_dockstatebar + $gui_docktop + $gui_dockleft)
	FillListView($gui_edit, $list_loops, $data)
	local $butt_top = $e_height - 25
	local $but_edit_up = GUICtrlCreateButton("&UP", 5, $butt_top, 40, 22)
	local $but_edit_down = GUICtrlCreateButton("&DOWN", 45, $butt_top, 40, 22)
	local $but_edit_del = GUICtrlCreateButton("Del&ete", 100, $butt_top, 40, 22)
	local $but_edit_sort = GUICtrlCreateButton("So&rt", 150, $butt_top, 40, 22)
	local $but_edit_cancel = GUICtrlCreateButton("&Cancel", $e_width - 105, $butt_top, 50, 22)
	local $but_edit_ok = GUICtrlCreateButton("&Save", $e_width - 45, $butt_top, 40, 22)
	for $i = $but_edit_up to $but_edit_sort
		GUICtrlSetResizing($i, $gui_docksize + $gui_dockleft)
	next
	for $i = $but_edit_cancel to $but_edit_ok
		GUICtrlSetResizing($i, $gui_docksize + $gui_dockright)
	next
	if $show_tips = $ON then
		GUICtrlSetTip($but_edit_up, " Move the selcted file(s) UP. ")
		GUICtrlSetTip($but_edit_down, " Move the selcted file(s) DOWN. ")
		GUICtrlSetTip($but_edit_del, " Delete the selected file(s) from the list. ")
		GUICtrlSetTip($but_edit_sort, " Sort the list (click again to reverse-sort). ")
		GUICtrlSetTip($but_edit_cancel, " Close this window and don't save any changes. ")
		GUICtrlSetTip($but_edit_ok, " Save any changes and close this window. ")
	endif
	GUISetState()
	while 1
		local $msg = GUIGetMsg()
		switch $msg
			case $gui_event_close, $but_edit_cancel
				exitloop
			case $but_edit_up
				MoveListViewItemsUP($gui_edit, $list_loops, $data)
			case $but_edit_down
				MoveListViewItemsDOWN($gui_edit, $list_loops, $data)
			case $but_edit_del
				DeleteListViewItem($gui_edit, $list_loops, $data)
			case $but_edit_sort
				SortListView($gui_edit, $list_loops, $data)
			case $but_edit_ok
				WriteArrayToPref($data, "wav_file")
				BuildCombo($combo_wav_file, "wav_file")
				exitloop
		endswitch
		local $size_array = WinGetPos(" Edit the Loop List..")
		if IsArray($size_array) and $size_array[2] < 310 then WinMove(" Edit the Loop List..", "", Default, Default, 310)
	wend
	GUIDelete($gui_edit)
	AutoItSetOption("GUICoordMode", $last_coord_mode)
	AutoItSetOption("GUIOnEventMode", $last_event_mode)
	DialogClose()
endfunc


func DoSplash($sp_msg, $sp_app, $sp_url)
	if $waited then return true
	AdLibRegister("SetWaited", 1000)
	local $last_event_mode = AutoItSetOption("GUIOnEventMode", 0)
	local $last_coord_mode = AutoItSetOption("GUICoordMode", 0)
	local $d_height = 55
	local $d_width = 180
	local $gui_info = GUICreate($sp_msg, $d_width, $d_height, -1, -1, Default, BitOR($WS_EX_TOOLWINDOW, $WS_EX_TOPMOST))
	GUICtrlCreateIcon($me_app, 0, 10, 10)
	GUICtrlCreateLabel($sp_app & " v" & $my_version & $MSG_LF & "from corz.org", 48, 0)
	GUISetState()
	while not $waited
		Sleep(25)
		local $msg = GUIGetMsg()
		switch $msg
			case $gui_event_close
				DoQuit(-33)
			case $gui_event_primarydown
				VisitURL($sp_url)
				$waited = true
		endswitch
	wend
	GUIDelete($gui_info)
	AutoItSetOption("GUIOnEventMode", $last_event_mode)
	AutoItSetOption("GUICoordMode", $last_coord_mode)
endfunc


func _______________STRING_FUNCS()
endfunc


func ConvertNames($some_path, $convert_level = 2)
	local $ab_file = $some_path
	local $ub_file = StringToBinary($some_path, $convert_level)
	$ab_file = BinaryToString($ub_file, 1)
	if $some_path <> $ab_file then
		$some_path = FileGetShortName($some_path)
	endif
	return $some_path
endfunc



func SortWAVFileList()
	SortComboPrefsList($combo_wav_file, "wav_file")
endfunc

func SortComboPrefsList(byref $control, $ini_prefname)
	if GUICtrlRead($control) == "" then return
	local $tmppref = GUICtrlRead($control)
	local $tmp = "|" & GrabComboPref($ini_prefname) & "|"
	local $array = StringSplit($tmp, "|")
	$array = BubbleSort($array)
	$tmp = "|"
	for $i = 1 to $array[0]
		if $i then $tmp &= $array[$i] & "|"
	next
	IniWrite($ini_path, $my_name, $ini_prefname, $tmp)
	BuildCombo($control, $ini_prefname)
	ControlCommand($LoopZGUI, "", $control, "selectString", $tmppref)
endfunc


func WriteArrayToPref(byref $data, $ini_prefname)
	if not IsArray($data) then return false
	local $tmp = "|"
	for $i = 1 to $data[0]
		if $data[$i] then
			$tmp &= $data[$i] & "|"
		endif
	next
	IniWrite($ini_path, $my_name, $ini_prefname, $tmp)
endfunc





func ______________SOUND_FUNCS()
endfunc

func PreviewWAV($path)

	debug("PreviewWAV(" & $path & ")...", @ScriptLineNumber, 5);debug

	local $memory = GetFreeMem()
	if FileGetSize($path) >= $memory then
		Beep(40, 150)
		Speak("2. Big!", 50, 5)
		exit -3
	endif
	$preview = true
	SetupTray()
	TraySetState(4)
	TraySetToolTip(" LoopDropZ..  " & $MSG_LF & " Previewing: " & CleanName($path) & " ")
	local $tray_abort = TrayCreateItem("Abort")
	TrayItemSetOnEvent(-1, "TrayQuit")
	TraySetClick(9)
	local $sound = _SoundOpen($path)
	_SoundPlay($sound)
	if _SoundStatus($sound) <> "" then
		while 1
			Sleep(100)
			if _SoundPos($sound, 2) >= _SoundLength($sound, 2) then exitloop
		wend
		_SoundCLose($sound)
	else
		TraySetToolTip(" LoopDropZ..  " & $MSG_LF & " Previewing: " & CleanName($path) & $MSG_LF & "[this sound cannot be aborted] ")
		TraySetState(8)
		TraySetClick(0)
		TrayItemDelete($tray_abort)
		SoundPlay($path, 1)
		SoundPlay("")
	endif
endfunc




; Loop an audio file..
;
func LoopSound($file, $noloop = false, $sync = false)

	debug("LoopSound(" & $file & "," & $noloop  & "," & $sync & ")...", @ScriptLineNumber, 5);debug

	local $loop = true
	if ce_IsPressed(10) or $noloop then $loop = false
	AdlibUnRegister("ResetTitle")
	DllCall("winmm.dll", "int", "PlaySoundA", "int", 0, "int", 0, "int", $snd_purge)
	GetSoundInfo($file)
	local $show_time = $wav_lenm
	local $memory = GetFreeMem()
	if $wav_size >= $memory then
		local $alert = MsgBox(4 + 48 + 256, "MEMORY ALERT!!!", _
			"The selected wav file is larger than the available system memory! " & $MSG_LF & _
			"Continuing could have unexpected and potentially disastrous effects." & $MSG_LF & $MSG_LF & _
			"Do you still wish to attempt to loop this file? ", 0, $LoopZGUI)
		if $alert <> 6 then
			WipeSingleComboItem($combo_wav_file, "wav_file")
			return false
		endif
	endif
	if $loop then
		$state = "Looping"
		DllCall("winmm.dll", "int", "PlaySoundA", "str", $file, "long", 0, "int", BitOR($SND_ASYNC, $SND_FILENAME, $SND_LOOP))
	else
		$state = "Playing"
		local $flags1 = BitOR($SND_ASYNC, $SND_FILENAME)
		if $sync then $flags1 = $SND_FILENAME
		DllCall("winmm.dll", "int", "PlaySoundA", "str", $file, "int", 0, "int", $flags1)
	endif
	TraySetTip($state & ": " & CleanName($file))
	local $my_title = " " & Chr(187) & Chr(187) & " " & $state & ": " & CleanName($file) & "  [" & $wav_len & "] " & _
						Chr(171) & Chr(171)
	
	if $keep_file_in_title = $ON then
		SetFixedTitle($my_title)
	else
		SetInfoTitle($my_title, $show_time)
	endif
	
	SetStopButton()
endfunc


func TrayLoopList()
	LoopList()
endfunc

#cs

l "B:\Archive\Entrainment\[Presets]\Brainwave Generator\primal7.wav" "B:\Archive\Entrainment\[Presets]\Brainwave Generator\chant.wav" "B:\Archive\Entrainment\[Presets]\Brainwave Generator\metadrop.wav"

l "B:\Archive\Entrainment\[Presets]\Brainwave Generator\deepend.wav" "B:\Archive\Entrainment\[Presets]\Brainwave Generator\Perfect5th.wav"

#ce

; Just messing about for now!
; A better idea would be to spawn copies of LoopDropZ, for perfect, multi-file
; SEAMLESS looping, which this isn't, quite. The small gap could be further
; shortened at the expense of CPU, I guess.

func SimpleLayer($file_array)

	debug("SimpleLayer()...", @ScriptLineNumber, 5);debug

	if not IsArray($file_array) then return false

	local $sounds_array[$file_array[0]+1] = [$file_array[0]+1]
	debug_PrintArray($file_array, "$file_array:", @ScriptLineNumber, 7);debug
	debug_PrintArray($sounds_array, "$sounds_array:", @ScriptLineNumber, 7);debug

	SetDropOff()
	SetStopButton()
	$unloop = false
	for $i = 1 to $file_array[0]

		local $file = $file_array[$i]

		local $memory = GetFreeMem()

		if FileGetSize($file) >= $memory then
			SetInfoTitle(" FILE TOO BIG FOR MEMORY! ")
			return false
		endif

		TraySetTip("Layering.. ")
		$sounds_array[$i] = _SoundOpen($file)
		_SoundPlay($sounds_array[$i])

	next

	debug_PrintArray($sounds_array, "$sounds_array:", @ScriptLineNumber, 7);debug

	while not $unloop
		for $i = 1 to $file_array[0]
			 if _SoundStatus($sounds_array[$i]) = "stopped" then _SoundPlay($sounds_array[$i])
		next
		Sleep(10)
	wend

	for $i = 1 to $file_array[0]
		_SoundClose($sounds_array[$i])
	next

	SetDropOn()
	TraySetTip()

endfunc


func LoopList()
	AdlibUnRegister("ResetTitle")
	SetStopButton()
	TrayItemSetState($tray_looplist, 128)
	$unloop = false
	$state = "LoopList"
	local $llist = GrabComboPref("wav_file")
	$llist = StringSplit($llist, "|")
	for $i = 1 to $llist[0]
		local $lpath = $llist[$i]
		;2do.. if audio is VBR, apparently, this may fail, better to use  _SoundOpen() initially 
		; and then use the returned array as the identity parameter in other _Sound...() functions. 
		if not FileExists($lpath) then continueloop
		local $lsnd = _SoundOpen($lpath)
		SetInfoTitle(" " & Chr(187) & Chr(187) & " Loop List: " & $i & " of " & $llist[0] & ": " & _
			CleanName($lpath) & "  [" & _SoundLength($lsnd) & "] " & Chr(171) & Chr(171), _SoundLength($lsnd, 2))
		_SoundPlay($lsnd)
		while _SoundPos($lsnd, 2) < _SoundLength($lsnd, 2)
			Sleep(100)
			if $unloop then
				$state = "Stopped"
				SetInfoTitle(" [" & $state & "]", $info_time / 2)
				_SoundCLose($lsnd)
				TrayItemSetState($tray_looplist, 64)
				return
			endif
		wend
		_SoundCLose($lsnd)
	next
	LoopList()
endfunc

func OverlapAudio($file)
	local $memory = GetFreeMem()
	if FileGetSize($file) >= $memory then
		SetInfoTitle(" FILE TOO BIG FOR MEMORY! ")
		return false
	endif
	local $sound = _SoundOpen($file)
	SetDropOff()
	local $tmplen = _SoundLength($sound)
	TraySetTip("Previewing: " & CleanName($file))
	SetInfoTitle(" " & Chr(187) & Chr(187) & _
				" Previewing: " & CleanName($file) & "  [" & $tmplen & "] [please wait]" & Chr(171) & Chr(171), $tmplen * 1000)
	_SoundPlay($sound)
	while 1
		Sleep(100)
		if _SoundPos($sound, 2) >= _SoundLength($sound, 2) then exitloop
	wend
	_SoundCLose($sound)
	SetDropOn()
	TraySetTip()
endfunc



func GetSoundInfo($file)
	local $sound = _SoundOpen($file)
	$wav_len = _SoundLength($sound)
	$wav_lenm = _SoundLength($sound, 2)
	$wav_size = FileGetSize($file)
	_SoundCLose($sound)
endfunc


func OldSpeak($text, $vol = 50, $rate = 1.1)
	local $o_speech = ObjCreate("SAPI.SpVoice")
	if not IsObj($o_speech) then return
	with $o_speech
		.rate = $rate
		.volume = $vol
		.Speak($text)
	endwith
endfunc


func comboUpdateSound()
	UpdateSound()
endfunc


func UpdateSound($startup = false)

	debug("UpdateSound(startup: " & $startup & ")...", @ScriptLineNumber, 5);debug

	local $file = GUICtrlRead($combo_wav_file)
	debug("$file: " & $file, @ScriptLineNumber, 7);debug

	if not FileExists($file) or GetExtension($file) <> "wav" then
		SetInfoTitle(" No such wav file! ", $info_time)
		WipeSingleComboItem($combo_wav_file, "wav_file")
		return false
	endif
	
	local $noloop = false
	if $startup then
		if $state = "Stopped" then
			SetInfoTitle(" [" & $state & "]", $info_time)
			return
		endif
		if $state = "Playing" then $noloop = true
	endif
	$state = "Stopped"
	LoopSound($file, $noloop)
endfunc


func HotKeyPlayOnce()
	switch $state
		case "Playing", "Looping", "LoopList"
			StopSound()
		case else
			$state = "Playing"
			UpdateSound(true)
	endswitch
endfunc

func ButtPlayStopButton()
	switch $state
		case "Looping", "Playing", "LoopList"
			StopSound()
		case else
			UpdateSound()
	endswitch
endfunc

func SetPlayButton()
	if $img_on_buttons = $ON then
		GUICtrlSetImage($but_playstop, @SystemDir & "\shell32.dll", -138, 0)
	else
		GUICtrlSetData($but_playstop, "loop")
	endif
	GUICtrlSetTip($but_playstop, " Click here to begin looping the selected wav file. (F8 or Ctrl+\)" & $MSG_LF & _
								" Hold down the SHIFT key to play the sound ONCE ONLY.  (F9 or Ctrl+/)")
	TraySetTip()
	TrayItemSetText($tray_loop, "Loop The Sound..	F8 or Ctrl+\")
endfunc

func SetStopButton()
	if $img_on_buttons = $ON then
		GUICtrlSetImage($but_playstop, @SystemDir & "\shell32.dll", -28, 0)
	else
		GUICtrlSetData($but_playstop, "stop")
	endif
	GUICtrlSetTip($but_playstop, " Click here to stop the sound. (F8, F9, Ctrl+\ or Ctrl+/) ")
	TrayItemSetText($tray_loop, "Stop The Sound..	F8 or Ctrl+\")
endfunc


func StopSound()
	DllCall("winmm.dll", "int", "PlaySoundA", "int", 0, "int", 0, "int", $snd_purge)
	$state = "Stopped"
	$unloop = true
	ResetTitle()
	SetPlayButton()
endfunc





func _________________CONTROLS()
endfunc

func SetDropOff()
	TraySetState(4)
	GUICtrlSetState($lab_dropzone, $gui_nodropaccepted)
	GUICtrlSetState($lab_dropzone, $gui_disable)
	GUICtrlSetState($lab_drop1, $gui_nodropaccepted)
	GUICtrlSetState($lab_wav_file, $gui_nodropaccepted)
	GUICtrlSetState($combo_wav_file, $gui_nodropaccepted)
	GUICtrlSetState($but_playstop, $gui_nodropaccepted)
endfunc

func SetDropOn()
	GUICtrlSetState($lab_dropzone, $gui_enable)
	GUICtrlSetState($lab_dropzone, $gui_dropaccepted)
	GUICtrlSetState($lab_drop1, $gui_dropaccepted)
	GUICtrlSetState($lab_wav_file, $gui_dropaccepted)
	GUICtrlSetState($combo_wav_file, $gui_dropaccepted)
	GUICtrlSetState($but_playstop, $gui_dropaccepted)
	TraySetState(8)
endfunc

func SortListView(byref $hwnd, byref $control, byref $data)
	if $lv_sort_flag then
		$data = BubbleSort($data)
		_arrayreverse($data, 1)
		$lv_sort_flag = false
	else
		$data = BubbleSort($data)
		$lv_sort_flag = true
	endif
	FillListView($hwnd, $control, $data)
endfunc

func MoveListViewItemsUP(byref $hwnd, byref $control, byref $data)
	if not IsArray($data) then return false
	local $item_id = ControlListView($hwnd, "", $control, "Getselected", 1)
	local $id_array = StringSplit($item_id, "|")
	for $j = 1 to $id_array[0]
		local $sel_idx = $id_array[$j]
		local $sel_item = ControlListView($hwnd, "", $control, "GetText", $sel_idx)
		if $sel_idx > 0 then
			_ArrayDelete($data, $sel_idx + 1)
			_ArrayInsert($data, $sel_idx, $sel_item)
		endif
	next
	FillListView($hwnd, $control, $data)
	for $j = 1 to $id_array[0]
		local $itm = $id_array[$j] - 1
		if $itm = -1 then $itm = 0
		ControlListView($hwnd, "", $control, "select", $itm)
	next
endfunc

func MoveListViewItemsDOWN(byref $hwnd, byref $control, byref $data)
	if not IsArray($data) then return false
	local $item_id = ControlListView($hwnd, "", $control, "Getselected", 1)
	local $id_array = StringSplit($item_id, "|")
	for $j = $id_array[0] to 1 Step -1
		local $sel_idx = $id_array[$j]
		local $sel_item = ControlListView($hwnd, "", $control, "GetText", $sel_idx)
		_ArrayDelete($data, $sel_idx + 1)
		local $ins = $sel_idx + 2
		if $ins > $data[0] then $ins = $data[0]
		_ArrayInsert($data, $ins, $sel_item)
	next
	FillListView($hwnd, $control, $data)
	for $j = $id_array[0] to 1 Step -1
		local $itm = $id_array[$j] + 1
		if $itm = $data[0] then $itm = $id_array[$j]
		ControlListView($hwnd, "", $control, "select", $itm)
	next
endfunc

func DeleteListViewItem(byref $hwnd, byref $control, byref $data)
	if not IsArray($data) then return false
	local $item_id = ControlListView($hwnd, "", $control, "Getselected", 1)
	local $id_array = StringSplit($item_id, "|")
	for $j = $id_array[0] to 1 Step -1
		_ArrayDelete($data, $id_array[$j] + 1)
		$data[0] -= 1
	next
	FillListView($hwnd, $control, $data)
endfunc

func FillListView($hwnd, byref $control, byref $data)
	debug("FillListView(" & $control & "," & $data & ")...", @ScriptLineNumber, 8);debug

	if not IsArray($data) then return false
	_guictrllistview_deleteallitems($control)
	for $i = 1 to $data[0]
		if $data[$i] then
			GUICtrlCreateListViewItem($data[$i], $control)
		endif
	next
	GUICtrlSendMsg($control, $lvm_setcolumnwidth, 0, $lvscw_autosize)
	ControlFocus($hwnd, "", $control)
endfunc

func GrabComboPref($ini_prefname)
	debug("GrabComboPref(" & $ini_prefname & ")...", @ScriptLineNumber, 5);debug

	local $tmp = IniRead($ini_path, $my_name, $ini_prefname, "")
	$tmp = StringStripWS($tmp, 3)
	$tmp = StringReplace($tmp, "||", "|")
	while StringRight($tmp, 1) = "|"
		$tmp = StringTrimRight($tmp, 1)
	wend
	while StringLeft($tmp, 1) = "|"
		$tmp = StringTrimLeft($tmp, 1)
	wend
	return $tmp
endfunc



; Bulds the WAVs combo box..
;
func BuildCombo(byref $control, $ini_prefname)
	debug("BuildCombo(" & $control & "," & $ini_prefname & ")...", @ScriptLineNumber, 5);debug

	GUICtrlSetOnEvent($combo_wav_file, "")
	local $data = GrabComboPref($ini_prefname)
	$data = StringSplit($data, "|")
	GUICtrlSetData($control, "")
	if $data[0] then
		for $i = 1 to $data[0]
			if $data[$i] then
				ControlCommand($LoopZGUI, "", $control, "AddString", $data[$i])
			endif
		next
		GUICtrlSetOnEvent($combo_wav_file, "ComboUpdateSound")
		ControlCommand($LoopZGUI, "", $control, "selectString", $data[$data[0]])
	endif
endfunc



; Add a string to the main combo box control..
;
func AddStringToCombo(byref $control, $new_str, $ini_prefname, $live_update = true)
	debug("AddStringToCombo(" & $control & "," & $new_str  & "," & $ini_prefname & "," & $live_update & ")...", @ScriptLineNumber, 5);debug

	local $tmp = "|" & GrabComboPref($ini_prefname) & "|"
	if $new_str <> "" and not StringInStr($tmp, "|" & $new_str & "|") then
		IniWrite($ini_path, $my_name, $ini_prefname, $tmp & $new_str & "|")
	endif
	if $live_update then
		ControlCommand($LoopZGUI, "", $control, "AddString", $new_str)
		ControlCommand($LoopZGUI, "", $control, "selectString", $new_str)
	endif
endfunc




func SetComboToCurrent(byref $control, $ini_prefname)

	debug("SetComboToCurrent(" & $control & "," & $ini_prefname &  ")...", @ScriptLineNumber, 5);debug

	if GUICtrlRead($control) = "" then return false
	local $tmp = "|" & GrabComboPref($ini_prefname) & "|"
	$tmp = StringReplace($tmp, "|" & GUICtrlRead($control) & "|", "|")
	IniWrite($ini_path, $my_name, $ini_prefname, $tmp & GUICtrlRead($control) & "|")
	BuildCombo($control, $ini_prefname)
endfunc

func LoadFavourites()
	LoadFaveGroup("favourites", "", $combo_wav_file, "wav_file")
endfunc

func SaveFavourites()
	local $exi_faves = IniRead($ini_path, $my_name, "favourites", "")
	if $exi_faves then
		local $def = IniRead($ini_path, $my_name, "ow_faves", "")
		if $def = "no" then SetInfoTitle(" No save performed, as per user default action.", $info_time)
		local $ret = YesNoMsgBox("Overwrite existing Faviourites?", _
								"Are you absolutely sure you wish to overwrite the existing Faviourites?  ", 0, $def)
		if @error = 1 then IniWrite($ini_path, $my_name, "ow_faves", $ret)
		if $ret <> "yes" then return false
	endif
	if SaveFaveGroup("favourites", "wav_file") then SetInfoTitle(" Favourites successfully saved.", $info_time)
endfunc

func AddToFavourites()
	local $fave = GUICtrlRead($combo_wav_file)
	AddStringToCombo($combo_wav_file, $fave, "favourites", false)
endfunc

func LoadFaveGroup($def_grp_pref, $default, byref $combo, $combo_pref)
	local $i = IniRead($ini_path, $my_name, $def_grp_pref, $default)
	IniWrite($ini_path, $my_name, $combo_pref, $i)
	BuildCombo($combo, $combo_pref)
endfunc

func SaveFaveGroup($def_grp_pref, $combo_pref)
	local $i = GrabComboPref($combo_pref)
	if $i = "" then return false
	local $def_grp = "|" & $i & "|"
	return IniWrite($ini_path, $my_name, $def_grp_pref, $def_grp)
endfunc





func WipeWAVFileItem()
	WipeSingleComboItem($combo_wav_file, "wav_file")
endfunc

func WipeWAVFileList()
	local $tmp
	if ce_IsPressed(10) then $tmp = GUICtrlRead($combo_wav_file)
	local $def = IniRead($ini_path, $my_name, "do_wipe", "")
	switch $def
		case "no"
			SetInfoTitle(" USER DEFAULT ACTION PREVENS WIPE ", $info_time / 2)
		case "yes"
			SetInfoTitle(" LIST WIPED ", $info_time / 2)
	endswitch
	local $ret = YesNoMsgBox("Really Wipe?", "Are you absolutely sure you wish to completely wipe the list?  ", 0, $def)
	if @error = 1 then IniWrite($ini_path, $my_name, "do_wipe", $ret)
	if $ret <> "yes" then return
	SetInfoTitle(" Loop List Wiped", $info_time / 2)
	WipeCombo($combo_wav_file, "wav_file", $tmp)
endfunc



func WipeCombo(byref $control, $ini_prefname, $tmp = "")
	IniWrite($ini_path, $my_name, $ini_prefname, "")
	BuildCombo($control, $ini_prefname)
	if $tmp then
		ControlCommand($LoopZGUI, "", $control, "AddString", $tmp)
		ControlCommand($LoopZGUI, "", $control, "selectString", $tmp)
	endif
endfunc



func WipeSingleComboItem(byref $control, $ini_prefname)
	if GUICtrlRead($control) = "" then return false
	local $tmp = "|" & GrabComboPref($ini_prefname) & "|"
	$tmp = StringReplace($tmp, "|" & GUICtrlRead($control) & "|", "|")
	IniWrite($ini_path, $my_name, $ini_prefname, $tmp)
	BuildCombo($control, $ini_prefname)
endfunc





func __________________SYSTEM()
endfunc



func TrayToggleWindow()
	ToggleWindow()
endfunc

func ToggleWindow()
	local $winstate = WinGetState($LoopZGUI)
	if BitAND($winstate, 2) then
		UnSetHotKeys()
		GUISetState(@SW_HIDE, $LoopZGUI)
		$visible = false
		_ReduceMemory()
	else
		GUISetState(@SW_SHOW, $LoopZGUI)
		$visible = true
		SetHotKeys()
	endif
endfunc

func ResizeCheckSize()
	CheckSize()
endfunc

func PrimaryUPCheckSize()
	CheckSize()
endfunc


func CheckSize($save=true)

	local $size_array = WinGetPos($LoopZGUI)
	if not IsArray($size_array) then return 0

	if $size_array[2] < $min_width + $width_magic then WinMove($LoopZGUI, "", Default, Default, $min_width + $width_magic)
	if $size_array[3] < $min_height + $height_magic then WinMove($LoopZGUI, "", Default, Default, Default, $min_height + $height_magic)

	Sleep(25)

	$size_array = WinGetPos($LoopZGUI)
	if not IsArray($size_array) then return 0

	if $size_array[0] > @DesktopWidth - $size_array[2] + 12 then
		WinMove($LoopZGUI, "", @DesktopWidth - $size_array[2], Default, Default)
	endif
	if $size_array[1] > @DesktopHeight - $size_array[3] + 12 then
		WinMove($LoopZGUI, "", Default, @DesktopHeight - $size_array[3], Default)
	endif

	Sleep(25)

	$size_array = WinGetPos($LoopZGUI)
	if not IsArray($size_array) then return 0

	if $size_array[0] < 0 then
		WinMove($LoopZGUI, "", 0, Default)
		if $save then IniWrite($ini_path, $my_name, "x", 0)
	endif
	if $size_array[0] > @DesktopWidth - $size_array[2] then
		WinMove($LoopZGUI, "", @DesktopWidth - $size_array[2] + 12, Default)
		if $save then IniWrite($ini_path, $my_name, "x", @DesktopWidth - $size_array[2])
	endif
	if $size_array[1] < 0 then
		WinMove($LoopZGUI, "", Default, 0)
		if $save then IniWrite($ini_path, $my_name, "y", 0)
	endif
	if $size_array[1] > @DesktopHeight - $size_array[3] + 12 then
		WinMove($LoopZGUI, "", Default, @DesktopHeight - $size_array[3])
		if $save then IniWrite($ini_path, $my_name, "y", @DesktopHeight - $size_array[3])
	endif

	return true

endfunc





func SaveXYPrefs()

	if not CheckSize() then return 0
	local $size_array = WinGetPos($LoopZGUI)
	if not IsArray($size_array) then return 0

	if $x <> $size_array[0] and $size_array[0] >= 0 and $size_array[0] < (@DesktopWidth - 25) then
		IniWrite($ini_path, $my_name, "x", $size_array[0])
	endif
	if $y <> $size_array[1] and $size_array[1] >= 0 and $size_array[1] < (@DesktopHeight - 25) then
		IniWrite($ini_path, $my_name, "y", $size_array[1])
	endif
	$size_array = WinGetClientSize($LoopZGUI)
	if not IsArray($size_array) then return 0

	if $size_array[0] <> $width and $size_array[0] >= $min_width then IniWrite($ini_path, $my_name, "width", $size_array[0])
	if $size_array[1] <> $height and $size_array[1] >= $min_height then IniWrite($ini_path, $my_name, "height", $size_array[1])

endfunc





func YesNoMsgBox($ynmb_title, $ynmb_text, $timeout=0, $default="", $hwnd=default)

	if $hwnd = default then $hwnd = $LoopZGUI

	local $curr = GUICtrlRead($combo_wav_file)
	if $default <> "" and $curr <> "" then return $default
	if $curr = "" then
		$hmm_wipe += 1
		if $hmm_wipe == 3 then
			$hmm_wipe = 0
			local $do_reset = MsgBox(1, "Reset this menu item to its default state?", _
				"This item has been deactivated by your (someone's!) request. " & $MSG_LF & _
				"Do you wish to reset the menu item's behaviour to its default state? ", 0, $hwnd)
			if $do_reset == 1 then
				IniDelete($ini_path, $my_name, "do_wipe")
				$default = ""
			endif
		endif
		if $default <> "" then
			DialogClose()
			return $default
		endif
	endif

	DialogOpen()
	local $last_event_mode = AutoItSetOption("GUIOnEventMode", 0)
	local $last_coord_mode = AutoItSetOption("GUICoordMode", 0)
	local $response = ""
	local $ynmb_width = 360

	if StringLen($ynmb_text) > 130 then $ynmb_width = StringLen($ynmb_text) * 2
	if $ynmb_width < 360 then $ynmb_width = 360
	local $ynmb_height = UBound(StringSplit($ynmb_text, $MSG_LF)) * 20 + 20

	if $hwnd then
		local $size_array = WinGetPos($LoopZGUI)
		local $ynmb_left = ($size_array[0] + ($size_array[2] / 2)) - ($ynmb_width / 2)
		local $ynmb_top = ($size_array[1] + ($size_array[3] / 3)) - ($ynmb_height / 3)
	else
		$ynmb_left = (@DesktopWidth / 2) - ($ynmb_width / 2)
		$ynmb_top = (@DesktopHeight / 2) - ($ynmb_height)
	endif

	local $style = BitOR($ws_caption, $ws_popup, $ws_sysmenu)
	local $ynmb = GUICreate($ynmb_title, $ynmb_width, $ynmb_height, $ynmb_left, $ynmb_top, $style, -1, $hwnd)
	GUICtrlCreateLabel($ynmb_text, 15, 10)
	local $but_yes = GUICtrlCreateButton("&Yes", -5, $ynmb_height - 37, 60, 25)
	local $but_no = GUICtrlCreateButton("&No", 70, 0, 60, 25, $bs_defpushbutton)
	local $chk_remember = GUICtrlCreateCheckbox("always do this action", 75, 0, Default, Default, BitOR($bs_right, $bs_autocheckbox))
	GUISetCoord($ynmb_width - 65, $ynmb_height - 28)
	local $but_cancel = GUICtrlCreateButton("A&bort", -1, -1, 60, 25)
	GUISetState(@SW_SHOW)

	if $timeout <> 0 then local $dialog_begin = TimerInit()

	Do
		local $msg = GUIGetMsg()
		switch $msg
			case $but_cancel, $gui_event_close
				exitloop
			case $but_yes
				$response = "yes"
			case $but_no
				$response = "no"
		endswitch

		if $timeout <> 0 then
			if TimerDiff($dialog_begin)/1000 > $timeout then
				exitloop
			endif
		endif

	until $response <> ""

	local $rem = GUICtrlRead($chk_remember)
	GUIDelete($ynmb)

	AutoItSetOption("GUICoordMode", $last_coord_mode)
	AutoItSetOption("GUIOnEventMode", $last_event_mode)

	DialogClose()

	return SetError($rem, $rem, $response)
endfunc




func _ReduceMemory()
	DllCall("psapi.dll", "int", "EmptyWorkingSet", "long", -1)
endfunc


func LaunchVolumeControl()
	local $default_vol = "SNDVOL32.EXE"
	if @OSArch = "X64" then $default_vol = "SNDVOL.EXE"
	local $volume_control = IniRead($ini_path, $my_name, "volume_control", $default_vol)
	Run($volume_control)
endfunc

func FadeIn($gui, $step = 5)
	WinSetTrans($gui, "", 0)
	GUISetState(@SW_SHOW, $gui)
	local $i = 100
	while $i >= 3
		WinSetTrans($gui, "", (100 - $i) * 2.55)
		Sleep(5)
		$step = $i / 9
		$i -= $step
	wend
	WinSetTrans($gui, "", 255)
	WinActivate($gui)
endfunc

func WindowToFront()
	if not $visible then return
	if $hover_to_show = $OFF then return
	if $timer_stamp = 0 or TimerDiff($timer_stamp) > 1000 then
		$timer_stamp = TimerInit()
	endif
	local $diff = TimerDiff($timer_stamp)
	if $diff > ((11 - $hover_sensitivity) * 100) then
		$timer_stamp = 0
		WinSetOnTop($LoopZGUI, "", 1)
		WinSetOnTop($LoopZGUI, "", 0)
		Sleep(100)
		WinActivate($LoopZGUI)
		RePaintGUI($LoopZGUI)
	endif
endfunc

func RePaintGUI($hwnd, $trect = 0, $hregion = 0, $iflags = 5)
	local $prect, $aresult
	if $trect <> 0 then $prect = DllStructGetPtr($trect)
	$aresult = DllCall("User32.dll", "int", "RedrawWindow", "hwnd", $hwnd, "ptr", $prect, "int", $hregion, "int", $iflags)
	if IsArray($aresult) then return ($aresult[0] <> 0)
endfunc

func SetAlwaysOnTop()
	if $always_on_top = $ON then
		WinSetOnTop($LoopZGUI, "", 1)
	else
		WinSetOnTop($LoopZGUI, "", 0)
	endif
endfunc

func ToggleAlwaysOnTop()
	if $always_on_top = $OFF then
		$always_on_top = $ON
	else
		$always_on_top = $OFF
	endif
	SetAlwaysOnTop()
	TrayItemSetState($tray_on_top, $always_on_top)
	IniWriteCheckboxValue($ini_path, $my_name, "always_on_top", $always_on_top)
endfunc


func TraySetTip($string = "")
	if $string then $string = $MSG_LF & " " & $string & " "
	TraySetToolTip(" LoopDropZ.. " & $string & $MSG_LF & " Left-click: Show/Hide | Right-click: Menu ")
endfunc


func SetShowTips()
	if $show_tips = $ON then
		GUICtrlSetTip($lab_dropzone, " You can drag and drop wav files *anywhere* onto LoopDropZ. " & $MSG_LF & _
								" The window resizes real small, too, so you can keep it away in the corner.")
		GUICtrlSetTip($lab_wav_file, " WAV File input. Drag wav files and folders of wav files onto here." & $MSG_LF & _
																	" NOTE: You can drag and drop anywhere on LoopDropZ. ")
		GUICtrlSetTip($combo_wav_file, " This drop-down stores all the wav files you've played." & $MSG_LF & _
															" Right-click this control for some drop-down options. ")
		GUICtrlSetTip($but_playstop, " Click here to begin looping the selected wav file. (F8 or Ctrl+\) " & $MSG_LF & _
													" Hold down the SHIFT key to play the sound ONCE ONLY. (F9 or Ctrl+/)")
	else
		for $i = $lab_dropzone to $but_playstop
			GUICtrlSetTip($i, "")
		next
	endif
endfunc

func ToggleShowTips()
	if $show_tips = $OFF then
		$show_tips = $ON
	else
		$show_tips = $OFF
	endif
	SetShowTips()
	TrayItemSetState($tray_show_tips, $show_tips)
	IniWriteCheckboxValue($ini_path, $my_name, "show_tips", $show_tips)
endfunc


; func MenuToggleExplorerContext()
	; if $explorer_context = $ON then
		; $explorer_context = $OFF
	; else
		; $explorer_context = $ON
	; endif
	; IniWriteCheckboxValue($ini_path, $my_name, "explorer_context", $explorer_context)
	; local $ret = SetExplorerContextMenu("wav", $explorer_context, false, "Play in LoopDropZ|LoopDropZ", "soundrec", "")
	; if $ret then
		; TrayItemSetState($tray_context, $explorer_context)
	; else
		; TrayItemSetState($tray_context, 128)
	; endif
; endfunc


; func MenuToggleExplorerDefault()
	; if $explorer_default = $ON then
		; $explorer_default = $OFF
	; else
		; $explorer_default = $ON
	; endif
	; IniWriteCheckboxValue($ini_path, $my_name, "explorer_default", $explorer_default)
	; local $ret = SetExplorerContextMenu("wav", $explorer_default, true, "Preview..", "soundrec", "preview")
	; if $ret then
		; TrayItemSetState($tray_def_cmd, $explorer_default)
	; else
		; TrayItemSetState($tray_def_cmd, 128)
	; endif
; endfunc

func MenuToggleStartWithWin()
	ToggleStartWithWindows()
endfunc

func ToggleStartWithWindows()
	if $start_with_windows = $ON then
		$start_with_windows = $OFF
	else
		$start_with_windows = $ON
	endif
	TrayItemSetState($tray_startup, $start_with_windows)
	IniWriteCheckboxValue($ini_path, $my_name, "start_with_windows", $start_with_windows)
	CheckStartupLink()
endfunc

func CheckStartupLink()
	local $lnk = @StartupDir & "\" & $my_name & ".lnk"
	if $start_with_windows = $ON then
		if not FileExists($lnk) then
			FileCreateShortcut(@ScriptFullPath, $lnk, "", "startup", "A WAV looper, for your seamless background audio..")
		endif
	else
		FileDelete($lnk)
	endif
endfunc

func MenuToggleStartMinimized()
	ToggleStartMinimized()
endfunc

func ToggleStartMinimized()
	if $start_minimized = $ON then
		$start_minimized = $OFF
	else
		$start_minimized = $ON
	endif
	TrayItemSetState($tray_startmin, $start_minimized)
	IniWriteCheckboxValue($ini_path, $my_name, "start_minimized", $start_minimized)
	CheckStartupLink()
endfunc

func DialogOpen()
	SetDropOff()
	GUISetState(@SW_DISABLE, $LoopZGUI)
	TraySetState(2)
	UnSetHotKeys()
endfunc

func DialogClose()
	TraySetState(1)
	GUISetState(@SW_ENABLE, $LoopZGUI)
	WinActivate($LoopZGUI)
	GUISwitch($LoopZGUI)
	SetHotKeys()
	SetDropOn()
endfunc


func SetFixedTitle($info)
	WinSetTitle($LoopZGUI, "", $my_title & ".." & "  " & $info)
endfunc

func SetInfoTitle($info, $time = "")
	if not $time then $time = $info_time
	AdlibUnRegister("ResetTitle")
	WinSetTitle($LoopZGUI, "", $my_title & ".." & "  " & $info)
	AdlibRegister("ResetTitle", $time)
endfunc

func ResetTitle()
	local $tmp_title = WinGetTitle($LoopZGUI)
	WinSetTitle($LoopZGUI, "", $my_title & "..")
	AdlibUnRegister("ResetTitle")
	if $state <> "Stopped" then
		if $wav_lenm < $info_time then
			WinSetTitle($LoopZGUI, "", $tmp_title)
			AdlibRegister("ResetTitle", $info_time - $wav_lenm)
			$wav_lenm = 1.7e+308
		endif
		if $state = "Playing" then StopSound()
	endif
endfunc


func SetWaited()
	$waited = true
	AdlibUnRegister("SetWaited")
endfunc





func _____________________HOTKEYS()
endfunc


func SetHotKeys()
	if ($use_hotkeys == $ON) then
		HotKeySet($hotkey_quit, "HK_DoQuit")
		HotKeySet("^o", "HK_OpenWAV")
		HotKeySet("^e", "HK_EditCombo")
		HotKeySet("^f", "HK_OpenWAVFolder")
		HotKeySet("^l", "HK_LoopList")
		HotKeySet("^a", "HK_LaunchVolumeControl")
		HotKeySet("^p", "HK_EditINIFile")
		HotKeySet("{F8}", "HK_PlayStop")
		HotKeySet("{F9}", "HK_PlayOnceStop")
		HotKeySet("^\", "HK_PlayStop2")
		HotKeySet("^/", "HK_PlayOnceStop2")
		HotKeySet("^{Del}", "HK_WipeWavFileItem")
		
		; HotKeySet($volume_up_key, "HK_WAVVolumeUP")
		; HotKeySet($volume_down_key, "HK_WAVVolumeDOWN")
		
		; HotKeySet($volume_big_up_key, "HK_WAVVolumeBigUP")
		; HotKeySet($volume_big_down_key, "HK_WAVVolumeBigDOWN")
	endif
endfunc



func UnSetHotKeys()
	if ($use_hotkeys == $ON) then
		HotKeySet($hotkey_quit)
		HotKeySet("^o")
		HotKeySet("^e")
		HotKeySet("^f")
		HotKeySet("^l")
		HotKeySet("^a")
		HotKeySet("^p")
		HotKeySet("{F8}")
		HotKeySet("{F9}")
		HotKeySet("^\")
		HotKeySet("^/")
		HotKeySet("^{Del}")
		
		; HotKeySet($volume_up_key)
		; HotKeySet($volume_down_key)
		; HotKeySet($volume_big_up_key)
		; HotKeySet($volume_big_down_key)

		ResetCTRLKey()
	endif
endfunc

func ResetCTRLKey()
	Send("{CTRLDOWN}")
	Send("{CTRLUP}")
endfunc

func HK_DoQuit()
	if WinActive($LoopZGUI) then
		DoQuit()
	else
		HotKeySet($hotkey_quit)
		Send($hotkey_quit)
		HotKeySet($hotkey_quit, "HK_DoQuit")
	endif
endfunc

func HK_OpenWAV()
	if WinActive($LoopZGUI) then
		OpenWAV()
	else
		HotKeySet("^o")
		Send("^o")
		HotKeySet("^o", "HK_OpenWAV")
		ResetCTRLKey()
	endif
endfunc

func HK_EditCombo()
	if WinActive($LoopZGUI) then
		EditCombo()
	else
		HotKeySet("^e")
		Send("^e")
		HotKeySet("^e", "HK_EditCombo")
		ResetCTRLKey()
	endif
endfunc

func HK_OpenWAVfolder()
	if WinActive($LoopZGUI) then
		OpenWAVfolder()
	else
		HotKeySet("^f")
		Send("^f")
		HotKeySet("^f", "HK_OpenWAVFolder")
		ResetCTRLKey()
	endif
endfunc

func HK_LaunchVolumeControl()
	if WinActive($LoopZGUI) then
		LaunchVolumeControl()
	else
		HotKeySet("^a")
		Send("^a")
		HotKeySet("^a", "HK_LaunchVolumeControl")
		ResetCTRLKey()
	endif
endfunc



func HK_WAVVolumeUP()
	if ($use_hotkeys == $ON) then
		$wav_volume += 1
		if $wav_volume > 100 then $wav_volume = 100
		SoundSetWaveVolume($wav_volume)
	endif
endfunc


func HK_WAVVolumeDOWN()
	if ($use_hotkeys == $ON) then
		$wav_volume -= 1
		if $wav_volume < 0 then $wav_volume = 0
		SoundSetWaveVolume($wav_volume)
	endif
endfunc


func HK_WAVVolumeBigUP()
	if ($use_hotkeys == $ON) then
		$wav_volume += $big_jump
		if $wav_volume > 100 then $wav_volume = 100
		SoundSetWaveVolume($wav_volume)
	endif
endfunc

func HK_WAVVolumeBigDOWN()
	if ($use_hotkeys == $ON) then
		$wav_volume -= $big_jump
		if $wav_volume < 0 then $wav_volume = 0
		SoundSetWaveVolume($wav_volume)
	endif
endfunc



func HK_EditINIFile()
	if WinActive($LoopZGUI) then
		EditINIFile()
	else
		HotKeySet("^p")
		Send("^p")
		HotKeySet("^p", "HK_EditINIFile")
		ResetCTRLKey()
	endif
endfunc

func HK_PlayStop()
	if WinActive($LoopZGUI) then
		ButtPlayStopButton()
	else
		HotKeySet("{F8}")
		Send("{F8}")
		HotKeySet("{F8}", "HK_PlayStop")
	endif
endfunc

func HK_PlayStop2()
	if WinActive($LoopZGUI) then
		ButtPlayStopButton()
	else
		HotKeySet("^\")
		Send("^\")
		HotKeySet("^\", "HK_PlayStop2")
		ResetCTRLKey()
	endif
endfunc

func HK_PlayOnceStop()
	if WinActive($LoopZGUI) then
		HotKeyPlayOnce()
	else
		HotKeySet("{F9}")
		Send("{F9}")
		HotKeySet("{F9}", "HK_PlayOnceStop")
	endif
endfunc

func HK_PlayOnceStop2()
	if WinActive($LoopZGUI) then
		HotKeyPlayOnce()
	else
		HotKeySet("^/")
		Send("^/")
		HotKeySet("^/", "HK_PlayOnceStop2")
		ResetCTRLKey()
	endif
endfunc

func hk_WipeWAVFileItem()
	if WinActive($LoopZGUI) then
		WipeWAVFileItem()
	else
		HotKeySet("^{Del}")
		Send("^{Del}")
		HotKeySet("^{Del}", "HK_WipeWavFileItem")
		ResetCTRLKey()
	endif
endfunc

func HK_LoopList()
	if WinActive($LoopZGUI) then
		TrayLoopList()
	else
		HotKeySet("^l")
		Send("^l")
		HotKeySet("^l", "HK_LoopList")
		ResetCTRLKey()
	endif
endfunc





func ___________FILES_AND_PATHS()
endfunc


func GetDroppedItem()
	local $drop_ok = ""
	for $i = 0 to UBound($droppedfiles) - 1
		local $dragfile = $droppedfiles[$i]
		if not FileExists($dragfile) then return false
		local $dropped_file = false
		local $nosubs = false
		if ce_IsPressed(10) then $nosubs = true
		if ce_IsPressed(11) then
			if GetExtension($dragfile) = "wav" or GetExtension($dragfile) = "mp3" then OverlapAudio($dragfile)
			return
		endif
		if IsDir($dragfile) then
			ImportWAVFolder($dragfile, $nosubs)
		else
			switch GetExtension($dragfile)
				case "wav"
					$dropped_file = $dragfile
				case "lnk"
					local $lnk_arr = FileGetShortcut($dragfile)
					select
						case IsDir($lnk_arr[0])
							ImportWAVFolder($lnk_arr[0], $nosubs)
						case GetExtension($lnk_arr[0]) = "wav"
							$dropped_file = $lnk_arr[0]
					endselect
				case else
					return false
			endswitch
		endif
		if $dropped_file then $drop_ok &= "|" & $dropped_file
	next
	if StringLen($drop_ok) then
		$drop_ok = StringTrimLeft($drop_ok, 1)
		local $add_files = StringSplit($drop_ok, "|", 2)
		for $i = 0 to UBound($add_files) - 1
			AddStringToCombo($combo_wav_file, $add_files[$i], "wav_file", false)
		next
		BuildCombo($combo_wav_file, "wav_file")
		ControlCommand($LoopZGUI, "", $combo_wav_file, "selectString", $add_files[0])
		UpdateSound()
	endif
endfunc



func DropfilesFunc($hwnd, $msgid, $wparam, $lparam)
#forceref $hwnd, $msgid, $lparam

	local $nsize, $pfilename
	local $d_arr = DllCall(@SystemDir & "\shell32.dll", "int", "DragQueryFile", _
														"hwnd", $wparam, _
														"int", -1, _
														"ptr", 0, _
														"int", 255)
	ReDim $droppedfiles[$d_arr[0]]
	for $i = 0 to $d_arr[0] - 1
		$nsize = DllCall(@SystemDir & "\shell32.dll",	"int", "DragQueryFile", _
														"hwnd", $wparam, _
														"int", $i, _
														"ptr", 0, _
														"int", 0)
		$nsize = $nsize[0] + 1
		$pfilename = DllStructCreate("char[" & $nsize & "]")
		DllCall(@SystemDir & "\shell32.dll",	"int", "DragQueryFile", _
												"hwnd", $wparam, _
												"int", $i, _
												"ptr", DllStructGetPtr($pfilename), _
												"int", $nsize)
		$droppedfiles[$i] = DllStructGetData($pfilename, 1)
		$pfilename = 0
	next
	GetDroppedItem()
endfunc

func OpenWAV()
	local $wavs_folder = IniRead($ini_path, $my_name, "wavs_folder", $data_dir & "\alerts")
	local $open_file = FileOpenDialog("Load a WAV file for looping..", $wavs_folder, "WAV Files (*.wav)", 1, "*.wav", $LoopZGUI)
	if GetExtension($open_file) = "wav" then
		AddStringToCombo($combo_wav_file, $open_file, "wav_file")
		BuildCombo($combo_wav_file, "wav_file")
		ControlCommand($LoopZGUI, "", $combo_wav_file, "selectString", $open_file)
		IniWrite($ini_path, $my_name, "wavs_folder", GetParent($open_file))
	endif
endfunc

func OpenWAVfolder()
	local $current = GUICtrlRead($combo_wav_file)
	local $load_folder = IniRead($ini_path, $my_name, "load_folder", $data_dir & "\alerts")
	local $open_folder = FileselectFolder("Load a folder of WAV files into the combo..", _
										"::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", 2, $load_folder, $LoopZGUI)
	local $nosubs = false
	if ce_IsPressed(10) then $nosubs = true
	if IsDir($open_folder) then
		ImportWAVFolder($open_folder, $nosubs)
		IniWrite($ini_path, $my_name, "load_folder", $open_folder)
	endif
	if $current then
		ControlCommand($LoopZGUI, "", $combo_wav_file, "selectString", $current)
	endif
endfunc

func ImportWAVFolder($dir, $do_recurse = true)
	SetInfoTitle("scanning for wav files in: " & BaseName($dir))
	local $list_o_wavs = RecurseDir($dir, "*.wav", $do_recurse)
	if IsArray($list_o_wavs) then
		for $i = 1 to $list_o_wavs[0]
			if $list_o_wavs[$i] <> "" then AddStringToCombo($combo_wav_file, $list_o_wavs[$i], "wav_file", false)
		next
		BuildCombo($combo_wav_file, "wav_file")
		ControlCommand($LoopZGUI, "", $combo_wav_file, "selectString", $list_o_wavs[1])
	endif
endfunc

func OpenCurrentWAVParent()
	if not GUICtrlRead($combo_wav_file) then ControlCommand($LoopZGUI, "", $combo_wav_file, "SetCurrentselection", 0)
	if not GUICtrlRead($combo_wav_file) then OpenWAV()
	if not GUICtrlRead($combo_wav_file) then
		SetInfoTitle(" No WAV File  =  NO WAV FOLDER! ", $info_time)
		return false
	endif
	local $parent = GetParent(GUICtrlRead($combo_wav_file))
	if not FileExists($parent) then
		OpenWAVfolder()
		return
	endif
	ShellExecute("Explorer.exe", '"' & $parent & '"')
endfunc

func IsWritable($test_path)
	local $test = IniWrite($test_path, $my_name, "write_test", 1)
	IniDelete($test_path, $my_name, "write_test")
	return $test
endfunc


func UpdateINI()
	local $old_version = IniRead($ini_path, $my_name, "version", 0)
	local $vcomp = _versioncompare($my_version, $old_version)
	switch $vcomp
		case 0, -1
			return false
	endswitch
	local $tmp_ini = @TempDir & "\" & $ini_file & ".new"
	FileInstall("Resources\LoopDropZ.ini", $tmp_ini, 1)
	local $existing_sections = IniReadSectionNames($tmp_ini)
	if IsArray($existing_sections) then
		for $a = 1 to $existing_sections[0]
			if $existing_sections[$a] <> $my_name then
				IniDelete($tmp_ini, $existing_sections[$a])
			endif
		next
	endif
	$existing_sections = IniReadSectionNames($ini_path)
	if IsArray($existing_sections) then
		for $a = 1 to $existing_sections[0]
			local $section = IniReadSection($ini_path, $existing_sections[$a])
			if IsArray($section) then
				for $b = 1 to $section[0][0]
					if StringLeft($section[$b][0], 1) <> "#" then
						IniWrite($tmp_ini, $existing_sections[$a], $section[$b][0], $section[$b][1])
					endif
				next
			endif
		next
	endif
	FileMove($ini_path, GetParent($ini_path) & "\[" & FileDateStamp() & "] " & $ini_file & ".ini")
	FileMove($tmp_ini, $ini_path, 1)
	IniWrite($ini_path, $my_name, "version", $my_version)
endfunc







func __________________BYE_NOW()
endfunc


func EventDoAboutBox()
	DoAboutBox($LoopZGUI)
endfunc

func DoAboutBox($my_gui)
	local $a_x = -1
	local $a_y = -1
	local $a_shunt = 0
	local $d_height = 105
	local $d_width = 260
	local $txt_l = 80
	if WinVisible($my_gui) then
		local $n_size_array = WinGetPos($my_gui)
		if IsArray($n_size_array) then
			$a_x = $n_size_array[0] + ($n_size_array[2] / 2) - ($d_width / 2)
			$a_y = $n_size_array[1] + ($n_size_array[3] / 2) - ($d_height)
		endif
		AboutBoxOpen($my_gui)
	endif
	local $last_event_mode = AutoItSetOption("GUIOnEventMode", 0)
	local $last_coord_mode = AutoItSetOption("GUICoordMode", 1)

	$gui_about = GUICreate(" About " & $my_name & "..", $d_width, $d_height + $a_shunt, $a_x, $a_y, Default, BitOR($WS_EX_TOOLWINDOW, $WS_EX_TOPMOST))
	GUISetBkColor(16777215)
	local $x1 = GUICtrlCreateLabel($my_name & " v" & $my_version & $MSG_LF & "from corz.org", $txt_l, 8)
	FileInstall("Resources\About.gif", @TempDir & "\", 1)
	local $pic
	if FileExists(@TempDir & "\About.gif") then
		$pic = GUICtrlCreatePic(@TempDir & "\About.gif", 6, 9, 64, 64)
	else
		$pic = GUICtrlCreateIcon($me_app, 0, 6, 9, 64, 64)
	endif
	local $x2 = GUICtrlCreateLabel("Do you want to visit the " & $my_name & $MSG_LF & "web page at this time?", $txt_l, $a_shunt + 40)
	local $gui_about_no = GUICtrlCreateButton("No, not right now", 10, $a_shunt + 80, 95, 22)
	GUICtrlSetTip(-1, " The other button is the one you want to click! ")
	local $gui_about_ok = GUICtrlCreateButton("Yes, let's do it!", $d_width - 104, $a_shunt + 80, 95, 22)
	GUICtrlSetTip(-1, " The link will open in your system default browser ")
	local $vbit = "x86"
	if @AutoItX64 = 1 then $vbit = "x64"
	local $lab_v = GUICtrlCreateLabel($vbit, $d_width - 19, 1, 18, 12)
	GUICtrlSetFont(-1, 8, 200, 0, "Lucida Console")
	FileInstall("Resources\About.wav", @TempDir & "\LoopDropZ-loopdigga-about.wav", 1)
	if FileExists(@TempDir & "\LoopDropZ-loopdigga-about.wav") then
		SoundPlay(@TempDir & "\LoopDropZ-loopdigga-about.wav", 0)
	endif
	GUISetState()
	local $count = 1
	local $my_action
	while 1
		$count += 1
		if Mod($count, 25) = 0 then
			GUICtrlSetColor($lab_v, 4473924)
		endif
		if Mod($count, 50) = 0 then
			GUICtrlSetColor($lab_v, 0)
		endif
		local $msg = GUIGetMsg()
		Sleep(33)
		switch $msg
			case $gui_event_close, $gui_about_no
				exitloop
			case $gui_about_ok
				$my_action = "url"
				exitloop
			case $pic
				if ce_IsPressed(10) then
					$my_action = "inp"
				else
					$my_action = "url"
				endif
				exitloop
			case $x1, $x2
				VisitURL($my_url)
			case $lab_v
				$my_action = "sysi"
				exitloop
		endswitch
	wend
	GUIDelete($gui_about)
	AutoItSetOption("GUICoordMode", $last_coord_mode)
	AutoItSetOption("GUIOnEventMode", $last_event_mode)
	switch $my_action
		case "url"
			VisitURL($my_url)
		case "sysi"
			SysInfoBox()
	endswitch
	if WinVisible($my_gui) then AboutBoxClose($my_gui)
endfunc

func AboutBoxOpen($my_gui)
	GUISetState(@SW_DISABLE, $my_gui)
	TraySetState(2)
endfunc

func AboutBoxClose($my_gui)
	TraySetState(1)
	GUISetState(@SW_ENABLE, $my_gui)
	WinActivate($my_gui)
	guiswitch($my_gui)
endfunc


func GetLogLocation($this_preset=$my_name)

	local $i = DeTokenizeString(IniRead($ini_path, $this_preset, "log_location", $log_location))

	if $i <> "-" then
		if $portable then
			if $i and TestFileWrite($i) then
				$log_location = $i
			else
				if TestFileWrite(@ScriptDir & "\" & $my_name & ".log") then
					$log_location = @ScriptDir & "\" & $my_name & ".log"
				endif
			endif
		elseif IsDir($i) and TestFileWrite($i & "\" & $my_name & ".log") then
			$log_location = $i & "\" & $my_name & ".log"
		elseif $i and TestFileWrite($i) then
			$log_location = $i
		else
			$log_location = @TempDir & "\" & $my_name & ".log"
		endif
	endif
	debug("$log_location set to: " & $log_location, @ScriptLineNumber, 7);debug

endfunc






func TrayQuit()
	DoQuit()
endfunc

func MenuDoQuit()
	DoQuit()
endfunc

func DoQuit($x=0)
	IniWriteCheckboxValue($ini_path, $my_name, "state", $state)
	IniWrite($ini_path, $my_name, "wav_volume", $wav_volume)
	DllCall("winmm.dll", "int", "PlaySoundA", "int", 0, "int", 0, "int", $snd_purge)
	if not $preview then
		SetComboToCurrent($combo_wav_file, "wav_file")
		SaveXYPrefs()
	endif
	
	FileDelete(@TempDir & "\About.gif")
	VersionCheckOnline($my_name, $versioncheck_url, $download_url, $ini_path, $my_name, $my_version)
	GUIDelete($LoopZGUI)
	exit $x
endfunc








; AutoIt Wrapper / Compiler directives..
;

#Region

; For resources included with FileInstall()
#pragma compile(Compression, 9)

;::dev::..
; If you want your binary NOW, comment this out..
#AutoIt3Wrapper_Run_Au3Stripper=Y

; See the notes above debug() for what /rsln does.
#Au3Stripper_Parameters=/StripOnly /rsln

; Like calling the wrapper with /debug, which we do anyway. This is handy, though ..
#AutoIt3Wrapper_Run_Debug_Mode=Y
#AutoIt3Wrapper_LogFile=%scriptdir%\wrapper.log
#AutoIt3Wrapper_UseX64=Y
#AutoIt3Wrapper_UseUpx=N
#AutoIt3Wrapper_Run_AU3Check=Y
#AutoIt3Wrapper_AU3Check_Parameters=-d -w 1 -w 2 -w 3 -w- 4 -w 5 -w 6 -w 7 -v 1
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=Y
#AutoIt3Wrapper_Run_Stop_OnError=Y
; Main program icon..
#AutoIt3Wrapper_Icon=.\Resources\Icons\LoopDropZ.ico


; Free-Form Res Fields..
#AutoIt3Wrapper_Res_Field=Author|corz.org
#AutoIt3Wrapper_Res_Field=Contact|windows@corz.org
#AutoIt3Wrapper_Res_Field=Instructions|Drop in WAV files and loop!
#AutoIt3Wrapper_Res_Field=Publisher|corz.org
#AutoIt3Wrapper_Res_Field=Web Page|http://corz.org/windows/software/loopdropz/
#AutoIt3Wrapper_Res_Field=Compiled|%date% %time%

; These now have their own fields..
#AutoIt3Wrapper_Res_ProductName=LoopDropZ
#AutoIt3Wrapper_Res_CompanyName=corz.org
#AutoIt3Wrapper_Res_LegalCopyright=corz.org

; Application's resource info..
#AutoIt3Wrapper_Res_Comment=LoopDropZ

; This is the one that shows up in Process Explorer..
#AutoIt3Wrapper_Res_Description=LoopDropZ - A Seamless Background Audio Looper
#AutoIt3Wrapper_Res_LegalCopyright=corz.org
#AutoIt3Wrapper_Res_ProductVersion=1

; I must get a shot of my son's Surface and see if this does anything! I suspect not.
; #AutoIt3Wrapper_Res_HiDpi=N

;#AutoIt3Wrapper_Res_Field=Build|Public Release
#AutoIt3Wrapper_Res_Field=Build|Beta Release
;#AutoIt3Wrapper_Res_Field=Build|DEBUG



; Run pre- & post-compile tasks elevated..
;
#AutoIt3Wrapper_Run_Before_Admin=Y
#AutoIt3Wrapper_Run_After_Admin=Y


; Tasks to perform BEFORE compilation..
;

;::dev::..
; You might want to comment this out (kills any running instance of LoopDropZ)..
#AutoIt3Wrapper_Run_Before=taskkill /F /T /IM LoopDropZ.exe
; But if you do, copying your new binary over (below) probably won't work.



; Tasks to perform AFTER compilation..
;

; Backup this version of the script (dropped into a backup.zip, below). So I don't have to remember to..
#AutoIt3Wrapper_Run_After=copy "%in%" 									".\%scriptfile% - %fileversion%.au3"

; Handy to keep a backup of the stripped version, too..
#AutoIt3Wrapper_Run_After=move /Y .\%scriptfile%_stripped.au3 			".\%scriptfile% - %fileversion%_stripped.au3"

;::dev::..
; Your copy of LoopDropZ may be somewhere else..
; Copy latest binaries to app folders (overwrites existing binary)..
#AutoIt3Wrapper_Run_After=copy "%outx64%" 								"C:\Program Files\corz\LoopDropZ\LoopDropZ.exe"




;::dev::..
; You can probably comment-out this entire next section.
; It relates to building the distribution and source packages.
;
; It has some useful commands for your reference, though.
;
; Move latest binaries, etc. to distro folder (out of the way of the source)..
#AutoIt3Wrapper_Run_After=mkdir "..\LoopDropZ"
#AutoIt3Wrapper_Run_After=move /Y "%outx64%" 							"..\LoopDropZ\LoopDropZ.exe"
#AutoIt3Wrapper_Run_After=mkdir "..\LoopDropZ\Info"
; Latest ini FYI..
#AutoIt3Wrapper_Run_After=copy ".\Itstory.txt" 							"..\LoopDropZ\Info\Itstory.txt"
#AutoIt3Wrapper_Run_After=copy ".\Resources\QuickStart.txt" 			"..\LoopDropZ\QuickStart.txt"
#AutoIt3Wrapper_Run_After=copy ".\Resources\LoopDropZ.ini" 				"..\LoopDropZ\Info\LoopDropZ.ini"
#AutoIt3Wrapper_Run_After=copy ".\Resources\About This Folder.txt" 		"..\LoopDropZ\Info\About This Folder.txt"
; Use master license file..
#AutoIt3Wrapper_Run_After=copy "..\..\Free Software License.txt" 		"..\LoopDropZ\Info\Free Software License.txt"
; Source pack update...
#AutoIt3Wrapper_Run_After=mkdir "..\LoopDropZ Source Pack"
#AutoIt3Wrapper_Run_After=mkdir "..\LoopDropZ Source Pack\Resources"
#AutoIt3Wrapper_Run_After=mkdir "..\LoopDropZ Source Pack\Resources\Icons"
#AutoIt3Wrapper_Run_After=copy "%in%" 								"..\LoopDropZ Source Pack\%scriptfile%.au3"
#AutoIt3Wrapper_Run_After=copy ".\Itstory.txt" 						"..\LoopDropZ Source Pack\Resources\Itstory.txt"
#AutoIt3Wrapper_Run_After=copy ".\Resources\About resources.txt" 	"..\LoopDropZ Source Pack\Resources\About resources.txt"
#AutoIt3Wrapper_Run_After=copy ".\Resources\About.gif" 				"..\LoopDropZ Source Pack\Resources\About.gif"
#AutoIt3Wrapper_Run_After=copy ".\Resources\About.wav" 				"..\LoopDropZ Source Pack\Resources\About.wav"
#AutoIt3Wrapper_Run_After=copy ".\Resources\cel.au3" 				"..\LoopDropZ Source Pack\Resources\cel.au3"
#AutoIt3Wrapper_Run_After=copy ".\Resources\corz_registry.au3" 		"..\LoopDropZ Source Pack\Resources\corz_registry.au3"
#AutoIt3Wrapper_Run_After=copy ".\Resources\LoopDropZ.ini" 			"..\LoopDropZ Source Pack\Resources\LoopDropZ.ini"
#AutoIt3Wrapper_Run_After=copy ".\Resources\QuickStart.txt" 		"..\LoopDropZ Source Pack\Resources\QuickStart.txt"
#AutoIt3Wrapper_Run_After=copy "..\..\Free Software License.txt" 	"..\LoopDropZ Source Pack\Resources\Free Software License.txt
#AutoIt3Wrapper_Run_After=copy ".\Resources\Icons\LoopDropZ.ico" 	"..\LoopDropZ Source Pack\Resources\Icons\LoopDropZ.ico"
#AutoIt3Wrapper_Run_After=Xcopy "..\..\stuff\Notepad++Goodies" 		"..\LoopDropZ Source Pack\Resources\Notepad++Goodies" /E /H /C /I
; Zip and multi-hash (MD5+SHA1) the distro and source pack for release..
; NOTE: The 7z and checksum program directories are in my %PATH% (System Properties >> Advanced >> Environment Variables).
#AutoIt3Wrapper_Run_After=7z.exe a -mx7 -tzip "..\LoopDropZ Beta v%fileversion%.zip" "..\LoopDropZ\"
#AutoIt3Wrapper_Run_After=7z.exe a -mx7 -tzip "..\LoopDropZ Beta Source Pack v%fileversion%.zip" "..\LoopDropZ Source Pack\"
#AutoIt3Wrapper_Run_After=checksum.exe cq-t "..\LoopDropZ Beta v%fileversion%.zip"
#AutoIt3Wrapper_Run_After=checksum.exe csq-t "..\LoopDropZ Beta v%fileversion%.zip"
#AutoIt3Wrapper_Run_After=checksum.exe cq-t "..\LoopDropZ Beta Source Pack v%fileversion%.zip"
#AutoIt3Wrapper_Run_After=checksum.exe csq-t "..\LoopDropZ Beta Source Pack v%fileversion%.zip"
; Backup this version of the source files to BackUp.zip..
#AutoIt3Wrapper_Run_After=7z.exe a -mx7 -tzip ".\BackUp.zip" ".\%scriptfile% - %fileversion%.au3"
#AutoIt3Wrapper_Run_After=7z.exe a -mx7 -tzip ".\BackUp.zip" ".\%scriptfile% - %fileversion%_stripped.au3"
; Finally, remove the (now-zipped) source files..
#AutoIt3Wrapper_Run_After=del /f /q ".\%scriptfile% - %fileversion%.au3"
#AutoIt3Wrapper_Run_After=del /f /q ".\%scriptfile% - %fileversion%_stripped.au3"


; Version (keep this!)..

; This is visible all over the place (explorer properties, on mouse hover, etc.)
; and also used internally for version checking and the about box..
#AutoIt3Wrapper_Res_Fileversion=0.7.3.2




#cs

Some tests..


l "B:\Archive\Entrainment\[Presets]\Brainwave Generator\chant.wav"  "B:\Archive\Entrainment\[Presets]\Brainwave Generator\primal7.wav" "B:\Archive\Entrainment\[Presets]\Brainwave Generator\metadrop.wav"

layer "B:\Archive\Entrainment\[Presets]\Brainwave Generator\chant.wav"  "B:\Archive\Entrainment\[Presets]\Brainwave Generator\primal7.wav" "B:\Archive\Entrainment\[Presets]\Brainwave Generator\metadrop.wav"

p "B:\Archive\Entrainment\[Presets]\Brainwave Generator\chant.wav"

p "B:\Archive\Entrainment\[Presets]\Brainwave Generator\metadrop.wav"


#ce

#EndRegion
